let withNutsButton = document.querySelector('#withNuts');
let withoutNutsButton = document.querySelector('#withoutNuts');
let menuDiv = document.querySelector('.menu');

// Get Ice cream with Nuts
async function getNuttyIceCream() {
    try{
        let response = await fetch('icecream.json');
        let icecream = await response.json();
        menuDiv.innerHTML = '';
        icecream.forEach(icecream => {
            if (icecream.hasNuts) {
                menuDiv.insertAdjacentHTML('beforeend',`
                 <div class="menu-item">
                 <h3>${icecream.name}</h3>
                 <p class="price">${icecream.price.toFixed(2)}</p>
                 <p class="description">${icecream.description}</p>
                 </div>   `)
            }
        });
    } catch(error) {
        console.log(error);
    }
};
withNutsButton.addEventListener('click', getNuttyIceCream);

// Get Ice cream without Nuts
async function getNutFreeIceCream() {
    try{
        let response = await fetch('icecream.json');
        let icecream = await response.json();
        menuDiv.innerHTML = '';
        icecream.forEach(icecream => {
            if (!icecream.hasNuts) {
                menuDiv.insertAdjacentHTML('beforeend',`
                 <div class="menu-item">
                 <h3>${icecream.name}</h3>
                 <p class="price">${icecream.price.toFixed(2)}</p>
                 <p class="description">${icecream.description}</p>
                 </div>   `)
            }
        });
    } catch(error) {
        console.log(error);
    }
};
withoutNutsButton.addEventListener('click', getNutFreeIceCream);